      SUBROUTINE GRAD_KOLYA(N_tpoints,inf1,inf2,inf3,delta_num,w_num, &
        toko1,toko2,tutu,gmax,inside_run,o_lef,o_rig,o_flag)
      USE Kolya_parameters; USE useful_parameters; USE ext_control_data
      IMPLICIT NONE;
      INTEGER,INTENT(IN) :: N_tpoints,delta_num,w_num
      REAL*8,DIMENSION(time_po),INTENT(IN) :: inf1, inf2, inf3
      REAL*8,DIMENSION(frec_num),INTENT(INOUT) :: toko1,toko2
      REAL*8,DIMENSION(time_po,frec_num),INTENT(IN)  :: tutu
      REAL*8,DIMENSION(frec_num),INTENT(IN) :: o_lef,o_rig
      INTEGER,INTENT(IN) :: o_flag
      DOUBLE PRECISION, EXTERNAL :: objective
      DOUBLE PRECISION, intent (OUT) :: gmax
      LOGICAL,INTENT(IN) :: inside_run
      LOGICAL :: poluchilos_li

      !PRINT*,tutu
      !STOP
      IF(w_num<4) RETURN

      
      
      allocate(N_int(w_num))
      IF(o_flag==0)THEN
        do i=1,w_num;
            N_int(i)=tutu(1,i);
        enddo
        Nor_ma=inf2(1)
       ELSE IF(o_flag==1)THEN
        do i=1,w_num; IF(i<delta_num+1) then
                      N_int(i)=1.d0;
                      ELSE;
                      N_int(i)=(o_rig(i)-o_lef(i))
                      ENDIF
        enddo
        Nor_ma=0.0d0
        DO i=1,delta_num
         Nor_ma = Nor_ma + toko2(i)
        ENDDO
        DO i=delta_num+1,w_num
         Nor_ma = Nor_ma + toko2(i)*(o_rig(i)-o_lef(i))
        ENDDO
      ELSE
        STOP"No such possibility for o_flag yet"
      ENDIF

!      PRINT*,'1'
      gmax=-1.d0
      Nt=N_tpoints
	  allocate(tgrid(Nt),gt(Nt),sigma_K(Nt))
	  do it=1,Nt
	   tgrid(it)=inf1(it)        ! time points
         gt(it)=inf2(it)           ! data ast these time points
           sigma_K(it)=inf3(it)      ! relative errors
             IF(kernel_type/=6 .AND. kernel_type/=7)THEN
	            sigma_K(it)=ABS(gt(it)*sigma_K(it)) ! actual error bars
             ENDIF   
      IF(sigma_K(it).le.0.d0) pause 'negative/zero sigma'
      !print*,sigma_K(1:nt); PAUSE"sig"
      !print*,gt(1:nt)
      !PAUSE"gt"
      enddo

      Mdelta=delta_num           !  number of delta-functions
      Mwmax=w_num                !  number of frequencies

      allocate(ogrid(Mwmax),go(Mwmax),oint(Mwmax,Nt))
	  allocate(dom(Mdelta+1:Mwmax-1))
	  allocate(gosave(Mwmax),gonsave(Mwmax))
      do io=1,Mwmax
	  ogrid(io) = toko1(io)      ! frequency points
      go(io) = toko2(io)         ! spectral density amplitudes
                                 ! at these points
      enddo
      gonsave=go                 ! save the starting point

	  do io=Mdelta+1,Mwmax-1
	  dom(io)=ogrid(io+1)-ogrid(io)  ! differences between frequency points
      IF(dom(io).le.0.d0) then
          print*, io, dom(io)
          print*, 'negative/zero interval'
          pause
      ENDIF
      enddo

	  do it=1,Nt; do io=1,Mwmax
	  oint(io,it) = tutu(it,io)    ! kernel integrated over the freq. width
      !IF(oint(io,it).le.0.d0) then
          !print*, io, it, tutu(it,io)
          !print*, 'negative/zero kernel'
          !pause
      !ENDIF
	  enddo; enddo

      allocate(AA(Mwmax,Mwmax),AAT(Mwmax,Mwmax))
      allocate(BB(Mwmax),BBT(Mwmax))

 !%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      allocate(Tfactor(Nt))
      allocate(Dfactor(Mdelta+1:Mwmax-1))
	  allocate(Afactor(Mwmax),D4factor(Mdelta+2:Mwmax-1,2))
      allocate(D2factor(Mdelta+2:Mwmax-1))

      do it=1,Nt
      Tfactor(it)=1.d0/(Nt*sigma_K(it)*sigma_K(it))
      enddo
      Nfactor=1.d0/(Nt*sigma_K(1)*sigma_K(1))
      call matrixini

      go to 4
      call smoothstart
 4    continue

!     initialize parameters
      errscale=1.d0
	  Dmin=1.d-4
      Dfactor=1.d4
      D2factor=1.d4
	  do io=Mdelta+2,Mwmax-1;
      D4factor(io,1)=1.d0 ;   D4factor(io,2)=go(io); enddo
	  Afactor=1.d-10
      obj1=objective()
!	  call tuneD

      Nfactor=100.d0/(Nt*sigma_K(1)*sigma_K(1))   ! enforce normalization
      call matrixini

	  errorscale0=16.d0
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
	  obj1=objective(); objectiveT0=objectiveT
!      print*, 'start', objectiveT*errscale , obj1
      gosave=go
	  objbest=objectiveT*errscale

      IF(inside_run) then
	  iterstop=20;  iterstop2=4; levelstep=0.25
	  Dscale=1.d-03; D4scale=2.d0; Yscale=20.d0
!      print*, 'inside run visited A'
      ELSE
	  iterstop=20;  iterstop2=4; levelstep=0.25
      Dscale=1.d-03; D4scale=2.d0
!       print*, 'inside run visited B'
	  ENDIF

	  cicle2: do iter2=1,iterstop2
                 IF(iter2>2) THEN;
                   Dscale=1.d01; D4scale=2.d02; Yscale=100.d0
                 ENDIF
	  cicle1: do iter1=1,iterstop

           IF(iter1<iterstop*0.1) then

! anneal error bars
	  errscale=errorscale0
	  ELSE IF(iter1<iterstop*0.3) then
	  errscale=max(errorscale0/2.d0,0.5d0)
	  ELSE IF(iter1<iterstop*0.6) then
	  errscale=max(errorscale0/4.d0,0.5d0)
	  ELSE IF(iter1<iterstop*0.9) then
	  errscale=max(errorscale0/8.d0,0.5d0)
	  ELSE
	  errscale=max(errorscale0/16.d0,0.5d0)
      ENDIF
	  IF(iter1==iterstop) errorscale0=errscale

      obj1=objective()
!      print*, 'before optimize', objectiveT*errscale, obj1, iter1
	  call optimize(poluchilos_li)
      IF(.NOT. poluchilos_li)THEN
            PRINT*,'Kolya ne smog' ;
            gmax=HUGE(gmax);
            KakaShiki=KakaShiki+1.0d0
            GOTO 111;
       ENDIF
!      obj1=objective()

!      print*, 'after optimize', objectiveT*errscale, obj1, iter1
!      pause

	  Dmin=max(1.d-012,Dmin/2.0d0)
	  call adjustA
!      obj1=objective()
!            print*, 'after adjust A', objectiveT*errscale, obj1, iter1
	  call adjustD
!      obj1=objective()
!            print*, 'after adjust D', objectiveT*errscale, obj1, iter1
      call adjustD2
!      obj1=objective()
!            print*, 'after adjust D2', objectiveT*errscale, obj1, iter1
	  call adjustD4
!      obj1=objective()
!            print*, 'after adjust D4', objectiveT*errscale, obj1, iter1
      call leveloff
!      obj1=objective()
!            print*, 'after leveloff', objectiveT*errscale, obj1, iter1
      IF(mod(iter1,3)==0) call smooth
!      obj1=objective()
!       print*, 'after smooth', objectiveT*errscale, obj1, iter1
!       pause

	  obj1=objective()
      IF(objectiveT .le. 0.d0  .or. objectiveT .gt.0.d0) then
         obj1=obj1
      else; PRINT*,'NAN in objective' ; !PAUSE
         gmax=HUGE(gmax); KakaShiki=KakaShiki+1.0d0
         GOTO 111;
      endif

      IF((iter1>1) .or. (iter2>1) ) then
       IF(objectiveT*errscale<objbest) then
	   objbest=objectiveT*errscale                    !better obj
	   gosave=go                                      !new saved
	   ENDIF
      ENDIF

!      print*, 'cicle1 done=', iter1, objectiveT
      enddo cicle1
!%%%%%%%%%%%%%%%%%
!	print*, 'cicle2 done=', iter2, objectiveT
	  enddo cicle2
!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

      go=gosave                                       ! using best
      do io=1,Mwmax
       IF(go(io) <background ) go(io)=background+1.d-6
	  enddo
	  call normalize
      obj1=objective()
	  !print*,  'chi^2=', objectiveT*errorscale
      gmax=-1.d0100
	  do io=Mdelta+1,Mwmax; IF(go(io)>gmax) gmax=go(io); enddo
	  gmax=gmax*1.5d0

      open(1,file='So.dat')                  ! produced spectral density
 	  do io=1,Mwmax
        write(1,*) ogrid(io), go(io)
	  enddo
	  close(1)

      do io=1,Mwmax
       toko2(io) = go(io)
	  enddo

!      stop 'job done'

111   CONTINUE

      deallocate(N_int)
	  deallocate(tgrid,gt,sigma_K)
	  deallocate(ogrid,go,oint,dom,gosave,gonsave)
      deallocate(AA,AAT,BB,BBT)
      deallocate(Tfactor)
      deallocate(Dfactor, Afactor,D4factor,D2factor)

      !PRINT*,"end_end"

      END SUBROUTINE Grad_Kolya
!_____________________________________________________
!-----------------------------------------------------
! central piece. Function to minimize
!_____________________________________________________
!-----------------------------------------------------
	  double precision function objective
      USE Kolya_parameters
      implicit none
	  double precision :: Aot(Nt)
	  double precision :: add
      integer :: op, om

      AA=AAT/errscale; BB=BBT/errscale; DD=DDT/errscale    ! chi^2 & norm term

 !     print*, 'Mdelta', Mdelta
      do io=Mdelta+1,Mwmax-1             ! first derivative term
        op=io+1
        add=Dfactor(io)/(dom(io)**2)
	    AA(io,io)= AA(io,io) + add
	    AA(op,op)= AA(op,op) + add
	    AA(io,op)= AA(io,op) - add
	    AA(op,io)= AA(op,io) - add
 !     print*, io,op
 !     print*, add, Dfactor(io),dom(io)
      enddo

 !       do io=1,Mwmax; do op=1,Mwmax
 !         x=AA(io,op)
 !      IF(x .le. 0.d0  .or.  x .gt.0.d0) then
 !        x=x
 !     else; PRINT*,'NAN in A first', x, io, op ; pause
 !     endif
 !     enddo; enddo

      do io=Mdelta+2,Mwmax-1             ! second derivative term
         op=io+1; om=io-1
      x= D2factor(io)/((dom(om)*dom(io))**2)
      add=x*(dom(om)**2)
	    AA(op,op)= AA(op,op)+add
      add=x*(dom(io)**2)
	    AA(om,om)= AA(om,om)+add
      add=x*( (dom(io)+dom(om))**2 )
	    AA(io,io)= AA(io,io)+add
      add=x*dom(io)*dom(om)
	    AA(om,op)= AA(om,op)+add
        AA(op,om)= AA(op,om)+add
      add=x*dom(om)*(dom(io)+dom(om))
	    AA(io,op)= AA(io,op)-add
        AA(op,io)= AA(op,io)-add
      add=x*dom(io)*(dom(io)+dom(om))
	    AA(io,om)= AA(io,om)-add
        AA(om,io)= AA(om,io)-add
      enddo

 !       do io=1,Mwmax; do op=1,Mwmax
 !         x=AA(io,op)
 !      IF(x .le. 0.d0  .or.  x .gt.0.d0) then
 !        x=x
 !     else; PRINT*,'NAN in A second', x, io, op ; pause
 !     endif
 !     enddo; enddo

      do io=1,Mwmax;   	                 ! amplitude term
	  AA(io,io)=AA(io,io)+Afactor(io)
	  BB(io)=BB(io)-2.d0*background*Afactor(io)
      DD=DD+(background**2)*Afactor(io)
      enddo

  !         do io=1,Mwmax; do op=1,Mwmax
  !        x=AA(io,op)
  !     IF(x .le. 0.d0  .or.  x .gt.0.d0) then
  !       x=x
  !    else; PRINT*,'NAN in A amplitude', x, io, op ; pause
  !    endif
  !    enddo; enddo


      do io=Mdelta+2,Mwmax-1      	             ! linearity term
	  AA(io,io)=AA(io,io)+D4factor(io,1)
	  BB(io)=BB(io)-2.d0*D4factor(io,2)*D4factor(io,1)
      DD=DD+(D4factor(io,2)**2)*D4factor(io,1)
      enddo

  !         do io=1,Mwmax; do op=1,Mwmax
  !        x=AA(io,op)
  !     IF(x .le. 0.d0  .or.  x .gt.0.d0) then
  !       x=x
  !    else; PRINT*,'NAN in A linearity', x, io, op ; pause
  !    endif
  !    enddo; enddo

      objective=0.d0; objectiveT=0.d0
      do io=1,Mwmax ; do ioo=1,Mwmax
	  objective =objective + AA(io,ioo)*go(io)*go(ioo)
	  objectiveT=objectiveT+AAT(io,ioo)*go(io)*go(ioo)/errscale
	  enddo
	  objective =objective + BB(io)*go(io)
	  objectiveT=objectiveT+BBT(io)*go(io)/errscale
	  enddo
	  objective =objective + DD
	  objectiveT=objectiveT+ DDT/errscale

  !    do io=1,Mwmax; do op=1,Mwmax
  !        x=AA(io,op)
  !     IF(x .le. 0.d0  .or.  x .gt.0.d0) then
  !       x=x
  !    else; PRINT*,'NAN in A', x, io, op ; pause
  !    endif
  !    enddo; enddo
  !
  !     do io=1,Mwmax
  !         x=BB(io)
  !     IF(x .le. 0.d0  .or.  x .gt.0.d0) then
  !       x=x
  !    else; PRINT*,'NAN in B', x, io ; pause
  !    endif
  !             x=go(io)
  !     IF(x .le. 0.d0  .or.  x .gt.0.d0) then
  !       x=x
  !    else; PRINT*,'NAN in go', x, io ; pause
  !    endif
  !    enddo
  !
  !                 x=DD
  !     IF(x .le. 0.d0  .or.  x .gt.0.d0) then
  !       x=x
  !    else; PRINT*,'NAN in D', x ; pause
  !    endif

!_________________________________________________________________

	  end function objective
!_________________________________________________________
!______________________________________________________________
      subroutine optimize(horosho_li)
      USE Kolya_parameters
      implicit none
      LOGICAL,INTENT(OUT) :: horosho_li
	  REAL*16 :: xm, t  , t1
      REAL*16, ALLOCATABLE :: Matrix(:,:), invMatrix(:,:)
      INTEGER :: i, j, nmat, ErrorFlag

      horosho_li = .TRUE.

      nmat=Mwmax
      ALLOCATE(Matrix(nmat,nmat))
      do i=1,nmat; do j=1,nmat; Matrix(i,j)=AA(i,j); enddo; enddo
      ALLOCATE(invMatrix(nmat,nmat))
      CALL FindInv(Matrix, invMatrix, nmat, ErrorFlag)
      IF(ErrorFlag==-1)THEN !stop 'something is worng in inversion'
          horosho_li = .FALSE.
          RETURN
      ENDIF

      do j=1,nmat; xm=0.d0;
      do i=1,nmat; xm=xm-0.5d0*invMatrix(j,i)*BB(i) ; enddo;
      go(j)=xm; enddo

      deallocate(Matrix,invMatrix)
	  end subroutine optimize
!_________________________________________________________
      subroutine adjustA
      USE Kolya_parameters
	  implicit none
      double precision :: controlA

      controlA=0.01d0/(Mwmax)
!analyze and correct A-factor
      do io=1,Mwmax
	  IF(go(io) <background ) then;
        Afactor(io)= Afactor(io)*10.d0
      ELSE
          IF(Afactor(io)*go(io)**2 > controlA) then
	      Afactor(io)=controlA/go(io)**2
          ELSE
          Afactor(io)= Afactor(io)/2.0d0
          ENDIF
      ENDIF
      IF(Afactor(io)>1.d08) Afactor(io)=1.d08
      IF(Afactor(io)<1.d-10) Afactor(io)=1.d-10
      enddo

	end subroutine adjustA
!______________________________________________________
      subroutine adjustD
      USE Kolya_parameters
	  implicit none
	  double precision :: controlD

      controlD=Dscale/(1.d0*Mwmax)

      do io=Mdelta+1,Mwmax-1
       y=Dfactor(io)
	   x=(go(io+1)-go(io))/dom(io)      ! w-derivative squared
	   x=(x*x)*y                        ! deviation despite penalties
	     IF(x>controlD) then                ! deviation is too large
	       Dfactor(io)=y*(controlD/x)       ! decrease penalty
        ELSE                               ! deviation small
          Dfactor(io)=y*1.5                ! increase penalty
        ENDIF
          IF(Dfactor(io)>Dmax) Dfactor(io)=Dmax
 	      IF(Dfactor(io)<Dmin)  Dfactor(io)=Dmin
      enddo

      Ymin=1.d10    ! define minimum of Dfactor
      do io=Mdelta+2,Mwmax-1; IF(Dfactor(io)<Ymin) then
	  Ymin=Dfactor(io); ENDIF ; enddo

      do io=Mdelta+2,Mwmax-1;  ! scale everything to Yscale*Ymin
	  x = 1. + (Yscale-1.)*Ymin/Dfactor(io)
      Dfactor(io) = Ymin * Yscale/x
      enddo

      end subroutine adjustD
!__________________________________________________________
      subroutine adjustD2
      USE Kolya_parameters
      implicit none
	  double precision :: controlD

      controlD=Dscale/(1.d0*Mwmax)

      do io=Mdelta+2,Mwmax-1
       y=D2factor(io)
	   x=dom(io-1)*go(io+1)+dom(io)*go(io-1)
       x=x-(dom(io)+dom(io-1))*go(io)
       x=x/( dom(io)*dom(io-1) )         ! 2d-derivative squared on the next line
	   x=(x*x)*y                         ! deviation despite penalties
	  IF(x>controlD) then                ! deviation is too large
	    D2factor(io)=y*(controlD/x)       ! decrease penalty
      ELSE                               ! deviation small
       D2factor(io)=y*1.5                ! increase penalty
      ENDIF
        IF(D2factor(io)>Dmax) D2factor(io)=Dmax
 	    IF(D2factor(io)<Dmin) D2factor(io)=Dmin
      enddo

      Ymin=1.d100    ! define minimum of Dfactor
      do io=Mdelta+2,Mwmax-1; IF(D2factor(io)<Ymin) then
	  Ymin=D2factor(io); ENDIF ; enddo

      do io=Mdelta+2,Mwmax-1;  ! scale everything to Yscale*Ymin
	  x = 1. + (Yscale-1.)*Ymin/D2factor(io)
      D2factor(io) = Ymin * Yscale/x
      enddo

      end subroutine adjustD2
!____________________________________________________________________
      subroutine adjustD4
      USE Kolya_parameters
      implicit none
      double precision :: controlD


      controlD=D4scale/(1.d0*Mwmax)

               IF(iter2<3) THEN               ! adjust penalty
      do io=Mdelta+1,Mwmax-2; ioo=io+1
       y=D4factor(ioo,1)
	   x=go(ioo)-D4factor(ioo,2)              ! deviation from target
	   x=(x*x)*y                              ! deviation despite penalties
	  IF(x>controlD) then                     ! deviation is too large
	    D4factor(ioo,1)=y*(controlD/x)        ! decrease penalty
      ELSE                                    ! deviation small
	    D4factor(ioo,1)=y*1.1                 ! increase penalty
      ENDIF
	    IF(D4factor(ioo,1)<Dmin) D4factor(ioo,1)=Dmin
        IF(D4factor(ioo,1)>Dmax) D4factor(ioo,1)=Dmax
      enddo
               ELSE
      y=-1.d100 ! find maximum
      do io=Mdelta+2,Mwmax-1;
      IF(D4factor(io,2)>y) y=D4factor(io,2); enddo

       do io=Mdelta+1,Mwmax-2; ioo=io+1
       x=ABS(D4factor(ioo,2))+y/20.d0
       D4factor(ioo,1)=controlD/(x*x)
       enddo
               ENDIF

      do io=1,Mwmax;
          IF(go(io)<background) go(io)=background+1.d-6;
      enddo

                      IF(iter2<3) THEN           ! adjust target
      do io=Mdelta+1,Mwmax-2; ioo=io+1
      z=( go(io+2)-go(io) )/( dom(io)+dom(ioo) )
      D4factor(ioo,2)=go(io)+z*dom(io)           ! new target
      IF(D4factor(ioo,2)<background) D4factor(ioo,2)=0.01
      enddo
                      ELSE
      ! preserve target, i.e. never update D4factor(ioo,2) except
      ! making it smooth if it is not
      do io=Mdelta+2,Mwmax-3; ioo=io+1
      IF(D4factor(ioo,2)<background) D4factor(ioo,2)=background+0.01 ;
      enddo ! correct if negative

      do io=Mdelta+2,Mwmax-3; ioo=io+1
         z=(D4factor(ioo+1,2) - D4factor(ioo-1,2) ) &
         /( dom(ioo-1)+dom(ioo) )
         x=D4factor(ioo-1,2)+z*dom(ioo-1)
        IF(ABS(D4factor(ioo,2)-x)/x > 0.5d0) D4factor(ioo,2)=x
! level of target
      enddo
                      ENDIF

      end subroutine adjustD4
!__________________________________________________________
      subroutine smooth
      USE Kolya_parameters; USE global_control
      implicit none
      REAL*8, EXTERNAL :: rndm
      double precision :: sd(Mdelta+1:Mwmax-1)
      double precision :: s4(Mdelta+2:Mwmax-1)
      integer :: ira

      ira=0; IF(rndm(k)>0.5d0) ira=1
      sd=Dfactor
      do io=Mdelta+3+ira,Mwmax-2,2
      x=(Dfactor(io-1)+Dfactor(io+1))/2.d0
      sd(io)=x
      enddo
      Dfactor=sd

      ira=0; IF(rndm(k)>0.5d0) ira=1
      s4=D4factor(:,1)
      do io=Mdelta+4+ira,Mwmax-2,2
      x=(D4factor(io-1,1)+D4factor(io+1,1))/2.d0
      s4(io)=x
      enddo
      D4factor(:,1)=s4

      IF(iter2<3) THEN                ! first two iterations only
      ira=0; IF(rndm(k)>0.5d0) ira=1
      s4=D4factor(:,2)
      do io=Mdelta+4+ira,Mwmax-2,2
      x=(D4factor(io+1,2)-D4factor(io-1,2))/(dom(io-1)+dom(io))
      x=D4factor(io-1,2)+dom(io-1)*x
      s4(io)=x
      enddo
      D4factor(:,2)=s4
      ENDIF

      end subroutine smooth
!__________________________________________________________

!__________________________________________________________
      subroutine normalize
      USE Kolya_parameters
	  implicit none
      double precision :: add,  y1 , add0
      logical          :: pass
      integer          :: countnorm

      add0=0.d0
	  do io=1,Mwmax; add0=add0+N_int(io)*go(io); enddo  ! curent normalization

	  y=background; y1=y; countnorm=0
	  normdo: do; pass=.TRUE.
        x=0.d0; do io=Mdelta+1,Mwmax;
	  IF(go(io) >background .AND. go(io)+1.1*y1>background) then
	  x=x+N_int(io); ENDIF; enddo      ! verifying how much we can borrow/add
	  y=(Nor_ma-add0)/x;               ! add this amount

	  do io=Mdelta+1,Mwmax;
	  IF(go(io) >background .AND. go(io)+1.1*y1>background) then
	  IF((go(io)+ y)<0.d0) then; pass=.FALSE. ; y1=y; ENDIF
	  ENDIF
	  enddo

	  IF(pass) then
        do io=Mdelta+1,Mwmax;
	  IF(go(io) >background .AND. go(io)+1.1*y1>background) then
	  go(io)=go(io)+y;
	  ENDIF
	  enddo
	  exit normdo
        ENDIF

      countnorm=countnorm+1
      IF(countnorm==40) exit normdo
	  enddo normdo

      add=0.d0
	  do io=1,Mwmax; add=add+N_int(io)*go(io); enddo

      IF(ABS(add-Nor_ma)>1.d-5)then
	  print*, 'Kolya normalization failed', add-Nor_ma
	  go=gonsave   ! back to saved file'
	  ENDIF

	  end subroutine normalize

!_________________________________________________
      subroutine leveloff
      USE Kolya_parameters; USE global_control
      implicit none
	DOUBLE PRECISION,EXTERNAL :: RNDM, objective
	integer :: ilevel, klevel
	double precision :: dg, add0, dg1, dg2, area, goasave(Mwmax)

! level off non-monotonic jumps in go-file
      obj1=objective(); obj1=objectiveT
      goasave=go

      do klevel=1,2
      ilevel=1+3.d0*rndm(k);
      do io=Mdelta+ilevel,Mwmax-3,3
	  x=(go(io+1)-go(io))/dom(io)
	  y=(go(io+2)-go(io+1))/dom(io+1)
	  z=(go(io+2)-go(io))/(dom(io+1)+dom(io))

	  dg=	(go(io)+z*dom(io)-go(io+1))*levelstep
      area=dg*oint(io+1,1)
	  dg1=area/(2.d0*oint(io,1))
	  dg2=area/(2.d0*oint(io+2,1))

	  x=go(io)  -dg1; IF(x>0.d0) go(io)=x
	  x=go(io+2)-dg2; IF(x>0.d0) go(io+2)=x
	  x=go(io+1)+dg;  IF(x>0.d0) go(io+1)=x

	  enddo   ! over frequencies
      enddo   !  klevel times

      obj2=objective(); obj2=objectiveT
      IF(obj2>obj1*2.d0) go=goasave

      end subroutine leveloff
!_________________________________________________
	  subroutine tuneD
      USE Kolya_parameters
	  implicit none
      DOUBLE PRECISION, EXTERNAL :: objective
	  integer :: tunecount

      print*,  'do not visit tuneD' ; pause
	  tunecount=1
	  tune: do
	  call adjustA
	  call adjustD
      call adjustD2
	  call adjustD4
      obj1=objective()
      IF(obj1<max(objectiveT*4.d0, 4.d0)) then; exit tune ; else ! good enough
 	  Dmin=Dmin/1.99d0; endif
      IF(Dmin<1.d-12) exit tune
      tunecount=tunecount+1
      enddo tune

 	  end subroutine tuneD
!_________________________________________________
	subroutine matrixini
      USE Kolya_parameters
	implicit none

      do io=1,Mwmax; do ioo=1,Mwmax
        x=0.d0;  do it=1,Nt;
        x=x + Tfactor(it)*oint(io,it)*oint(ioo,it)         ! error bars
	  enddo
      AAT(io,ioo)=x
      AAT(io,ioo)=AAT(io,ioo)+Nfactor*N_int(io)*N_int(ioo)      ! enforced normalization
      enddo; enddo

      do io=1,Mwmax
        x=0.d0;  do it=1,Nt;
        x=x -2.d0*Tfactor(it)*oint(io,it)*gt(it)                 ! error bars
	  enddo
      BBT(io)=x
      BBT(io)=BBT(io)-2.d0*Nfactor*N_int(io)*Nor_ma              ! enforced normalization
      enddo

      DDT=0.d0;  do it=1,Nt;
      DDT=DDT + Tfactor(it)*gt(it)*gt(it); enddo
      DDT=DDT + Nfactor*Nor_ma*Nor_ma

 	  end subroutine matrixini
!___________________________________________________
      subroutine smoothstart
      USE Kolya_parameters;
	  implicit none

      x=0.d0;
      IF(Mdelta>0) then
      do io=1,Mdelta; x=x+go(io)*oint(io,1); enddo ! delta contributions
      ENDIF
	  x=gt(1)-x                                            ! continuum weight
      y=0.d0; do io=Mdelta+1,MWmax; y=y+oint(io,1); enddo
	  x=x/y                                                ! expected height limit
	  IF(Mwmax-Mdelta<3) then
	    do io=Mdelta+1,Mwmax; go(io)=x; enddo                 ! constant for couple of points
      ELSE
	    y=(ogrid(Mwmax)+ogrid(Mdelta+1))/2.d0
	    z=(ogrid(Mwmax)-ogrid(Mdelta+1))/2.d0
	    x=1.5d0*x
        do io=Mdelta+1,Mwmax
        go(io)=x*(1.d0-((ogrid(io)-y)**2)/(z**2))         ! parabola
	    enddo
	  ENDIF

      end subroutine smoothstart

!________________________________________________________

      SUBROUTINE FINDInv(matrix, inverse, n, errorflag)
  	  IMPLICIT NONE
!Declarations
	  INTEGER, INTENT(IN) :: n
	  INTEGER, INTENT(OUT) :: errorflag  !Return error status. -1 for error, 0 for normal
	  REAL*16, INTENT(IN),  DIMENSION(n,n) :: matrix  !Input matrix
	  REAL*16, INTENT(OUT), DIMENSION(n,n) :: inverse !Inverted matrix

	  LOGICAL :: FLAG = .TRUE.
	  INTEGER :: i, j, k, l
	  REAL*16 :: m
	  REAL*16, DIMENSION(n,2*n) :: augmatrix !augmented matrix

!Augment input matrix with an identity matrix
	  DO i = 1, n
		DO j = 1, 2*n
			IF (j <= n ) THEN
				augmatrix(i,j) = matrix(i,j)
			ELSE IF ((i+n) == j) THEN
				augmatrix(i,j) = 1.d0
			Else
				augmatrix(i,j) = 0.d0
			ENDIF
		END DO
	  END DO

!Reduce augmented matrix to upper traingular form
	  DO k =1, n-1
		IF (augmatrix(k,k) == 0.d0) THEN
			FLAG = .FALSE.
			DO i = k+1, n
				IF (augmatrix(i,k) /= 0) THEN
					DO j = 1,2*n
						augmatrix(k,j) = augmatrix(k,j)+augmatrix(i,j)
					END DO
					FLAG = .TRUE.
					EXIT
				ENDIF
				IF (FLAG .EQV. .FALSE.) THEN
					PRINT*, "Matrix is non - invertible"
					inverse = 0.d0
					errorflag = -1.d0
					return
				ENDIF
			END DO
		ENDIF
		DO j = k+1, n
			m = augmatrix(j,k)/augmatrix(k,k)
			DO i = k, 2*n
				augmatrix(j,i) = augmatrix(j,i) - m*augmatrix(k,i)
			END DO
		END DO
	  END DO

!Test for invertibility
	  DO i = 1, n
		IF (augmatrix(i,i) == 0.d0) THEN
			PRINT*, "Matrix is non - invertible"
			inverse = 0.d0
			errorflag = -1
			return
		ENDIF
	  END DO

!Make diagonal elements as 1
	  DO i = 1 , n
		m = augmatrix(i,i)
		DO j = i , (2 * n)
			   augmatrix(i,j) = (augmatrix(i,j) / m)
		END DO
	  END DO

!Reduced right side half of augmented matrix to identity matrix
  	  DO k = n-1, 1, -1
		DO i =1, k
		m = augmatrix(i,k+1)
			DO j = k, (2*n)
				augmatrix(i,j) = augmatrix(i,j) -augmatrix(k+1,j) * m
			END DO
		END DO
	  END DO

!store answer
	   DO i =1, n
		DO j = 1, n
			inverse(i,j) = augmatrix(i,j+n)
		END DO
	   END DO
	    errorflag = 0
      END SUBROUTINE FINDinv

